<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resturant extends Model 
{

    protected $table = 'resturants';
    public $timestamps = true;

    public function items()
    {
        return $this->hasMany('App\Models\Item');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Payment');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Models\Resturant_Category');
    }

    public function tokens()
    {
        return $this->morphMany('App\Models\Resturant');
    }

    public function notifactions()
    {
        return $this->morphMany('App\Models\Notifacation');
    }

    public function neighborhoods()
    {
        return $this->belongsTo('App\Models\Neighborhood');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer');
    }

    public function product()
    {
        return $this->hasMany('App\Models\Product');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

}